#! /usr/bin/env python
# -*- coding: utf-8 -*-
# TIME OF CREATION Sat May 16 20:03:10 2009

''' 
	\package   src.stringUtil
	Вспомогательные функции для работы со строками 
	
	Не хотелось что бы они мешались
	где-то \n
	
	\file stringUtil.py
	смотрите src.stringUtil

'''


## максимальный размер символа в битах
UTF_SYMBOLSIZE = 8



# STING2LONG	
# *********************************************************

def sting2long(string):
	'''
		Переводит строку в число
		
		принцип: \n
			закодируем сторку как 16-ричное число; \n
			вычисляем с него long() в 16-ричной системе; \n
			пробел вначале - решение проблемы ведуших спец символов
	'''
	string = " " + string
	a =  string.encode('hex') 
	res = long(a, 16)
	return res
	
# LONG2STRING	
# *********************************************************
	
def  long2string(long):
	'''
		Переводит число в строку
		
		принцип: \n
			переводим число в строку с его 16-ричным представлением; \n
			обрубаем ведущие 0x << hex(long)[2:] >> ; \n
			если Python посчитал его long int обрубаем суффикс L; \n
			pacкодируем сторку как 16-ричное число; \n
			пробел вначале - решение проблемы ведуших спец символов
	'''
	hstring = hex(long)[2:]
	
	if 'L' in hstring:
		hstring = hstring[:-1]
		
	string = hstring.decode('hex') 
	return string[1:]
	
# STING2LONG	
# *********************************************************

def sting2blocks(string, blockSize):
	'''
		Переводит строку в строковые блоки 
		
		@param string
			входная строка 
			
		@param blockSize
			размер блока в символах
		
		Переводит строку в строковые блоки  
		размером blockSize, если остаток от деления 
		len (string) на blockSize не ноль, 
		то остаток строки идет отдельным блоком
	'''
	
	slen = len (string)
	res = []
	if(slen < blockSize):
		return [string]
		
	for i in xrange(slen/blockSize):
		res.append(string[i*blockSize: (i+1)*blockSize])
	rest = slen % blockSize	
	if(rest):
		res.append(string[ -rest :  ])
	
	return res
	
	
# ENCRYPTION2STRING	
# *********************************************************

def encryption2string(encryptList):
	'''
		Переводит список зашифрованных 
		блоков в строку
		
		Используется для ввода 
		зашифрованного сообщения
	'''
	resStr = ""
	for i in encryptList:
		s = hex(i)
		resStr += s
	return resStr

# STRING2ENCRYPTION	
# *********************************************************

def string2encryption(string):
	'''
		Переводит строку с список зашифрованных блоков
		
		исспользуется для ввода заштфрованного 
		собщения для ешо посдедующей расштфровки
	'''
	resList = []
	strlist = string.split('0x')[1:]
	for i in strlist:
		num = "0x%s"%i
		mess = long( num , 16)
		resList.append( mess )
	return resList

	
# ======================== ========================
# TEST FUNCTION
# ======================== ========================
def test():
	'''
	 Отладочная функция

	 Отладка теста  src.stringUtil
	'''
	print sting2blocksLong('Тоня', 128)
	
# MAIN RUNs
# *************************************************
if (__name__ == '__main__'):
	''' 
		Выполняем в пространсве имен __main__
		Выполнится только в случае запуска этого файла
	'''
	test()
	
	
	