#! /usr/bin/env python
# -*- coding: utf-8 -*-
# TIME OF CREATION Sat May 16 20:03:10 2009

''' 
	\package   src.numericUtil
	Вспомогательные функции для работы с числами
	
	Не хотелось что бы они мешались
	где-то \n
	Тут использован пакет gmpy
	
	\file numericUtil.py
	смотрите src.numericUtil

	\package  gmpy
	\brief GMP для Python 

		http://gmpy.sourceforge.net/
		\n
		Библиотека GMP используется для работы над знаковыми целыми, 
		рациональными числами и числами с плавающей точкой. 
		Главная особенность библиотеки — разрядность чисел (precision) практически неограничена. 
		Поэтому основная область применения — криптография, 
		компьютерные алгебраические вычисления и др. 
		Распространяется по лицензии GNU LGPL и является частью project GNU.
		<p>
		Тут она оказалась нужна так как стандартные математические
		операции Python, обладая неограниченной разрядностью,
		весьма медленны (((
		</p>
'''
try:
	import gmpy_
	# Попытаемся загрузить
	# GMPY (http://gmpy.sourceforge.net/)
	# модуль для ускорения арифметических операций
	
	gmpyLoaded = True
	
except ImportError:
	# если ее нет реализуем сами то что нужно
	# используя результаты первой лабы
	
	gmpyLoaded = False

# ================================================================================
# РАБОТА СО ЧИСЛАМИ
# ================================================================================

import random 
import math
	# импортируем стандартный модуль работы со случайными числами 
	# и cтандартный модуль работы c математическими фунуциями

import fw_1.MillerRabin
import fw_1.Util
import fw_1.GCD
	# импортируем модуль с тестом Миллера-Рабина
	# модуль для работы с НОД
	# и модуль вспомогательных функций из л.р. 1
	
# INVMOD	
# *********************************************************
	
'''
	\overload [invMod]
	псевдоним для invMod из src.fw_1.Util
	
	просто присваивание функции
'''	

invMod = fw_1.Util.invMod

# POWMOD	
# *********************************************************

'''
	\overload [powMod]
	псевдоним для powMod из src.fw_1.Util
	
	просто присваивание функции
'''	

powMod = fw_1.Util.powMod

# GCD	
# *********************************************************

'''
	\overload [gcd]
	псевдоним для powMod из src.fw_1.GCD.euklid
	
	просто присваивание функции
'''	

gcd = fw_1.GCD.euklid

# BITLEN	
# *********************************************************

def bitLen(x):
	return int(math.log10(x)/math.log10(2)) + 1
	
# GENPRIME	
# *********************************************************

def genPrime(lenbit = 1024):
	'''
	Генерация простого числа по заданному количеству бит
	
		использование gmpy определяется переменной useGmp
		если gmpy нет то будет использоваться тест Миллера-Рабина
		из первой лабораторной
	'''
	useGmp = gmpyLoaded
	if(useGmp):
		isPrime = gmpy.is_prime
	else:
		isPrime = fw_1.MillerRabin.MillerRabinTest
	res = 666
	while ( not isPrime( res )):
		res = random.getrandbits(lenbit)
	return res
	
# FERMA	
# *********************************************************

def ferma(n):
	'''
	Генератор чисел Ферма
	'''
	power = 2**n
	res = 2**power + 1
	return res

# EULERPHI	
# *********************************************************

def eulerPhi(p, q):
	'''
		Функция Эйлера
		
		\varphi(n), где n — натуральное число, 
		равна количеству натуральных чисел, 
		не больших n и взаимно простых с ним. \n
		
		для нашего n 
		\varphi(n) = (p - 1)*(q - 1)
	'''
	return (p - 1)*(q - 1)
	
	
	
# ======================== ========================
# TEST FUNCTION
# ======================== ========================
def test():
	'''
	 Отладочная функция

	 Отладка теста  src.numericUtil
	'''
	prime = genPrime()
	print prime
	print fw_1.MillerRabin.MillerRabinTest(prime)
	print ferma(2)
	
	
# MAIN RUNs
# *************************************************
if (__name__ == '__main__'):
	''' 
		Выполняем в пространсве имен __main__
		Выполнится только в случае запуска этого файла
	'''
	test()
	
	
	