#! /usr/bin/env python
# -*- coding: utf-8 -*-
# TIME OF CREATION Sun Mar 22 12:47:39 2009


# * Copyright (c) w495, 2009 
# *
# * All rights reserved.
# *
# * Redistribution and use in source and binary forms, with or without
# * modification, are permitted provided that the following conditions are met:
# *     * Redistributions of source code must retain the above copyright
# *       notice, this list of conditions and the following disclaimer.
# *     * Redistributions in binary form must reproduce the above copyright
# *       notice, this list of conditions and the following disclaimer in the
# *       documentation and/or other materials provided with the distribution.
# *     * Neither the name of the w495 nor the
# *       names of its contributors may be used to endorse or promote products
# *       derived from this software without specific prior written permission.
# *
# * THIS SOFTWARE IS PROVIDED BY w495 ''AS IS'' AND ANY
# * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# * DISCLAIMED. IN NO EVENT SHALL w495 BE LIABLE FOR ANY
# * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


''' 
	\package   src.config
	Конфигурация программы 
	
	Задание входных и выходных файлов.
	Для RSA используется косвенно,
	потому не нужно сильно вникать что сдесь происходит
	
	\file config.py
	смотрите src.config
'''



'''
	USAGE Выводится как помощь
	
		-i ИЛИ --input=		задает файл который мы хотим зашифровать 
			
		-o ИЛИ --output=	задает  файл c шифром 
			
		-c ИЛИ --check= 	задает  файл с рассшифровкой 
			
		-z ИЛИ --zip 		если установлен  файл c шифром будет сжат 
			
		-h ИЛИ --help 		покажет помощь 
'''

USAGE="""
Symple RSA coding.

USAGE:
	%s 	
	
		[ [ -i ] | [ --input= ] file_name  ]
		 |	[ [ -o ] | [ --output= ] file_name ]
		 |	[ [ -c ] | [ --check= ] file_name  ]
		 |	[ [ -h ] | [ --help ] ] 
		 |	[ [ -z ] | [ --zip ] ]

	parametres :
	
		-i OR --input=		set the input file that we what to encrypt
				
			if there is no such parametr, 
			it uses input.txt
			
		-o OR --output=		set the file with code
		
			if there is no such parametr, 
			it uses code.txt				
			
		-c OR --check= 		set the file with decripted code
		
			if there is no such parametr, 
			it uses obtained.txt 
			
		-z OR --zip 		compress file with code
		-h OR --help 		show this text
		
REPORT BUGS:

	ilia@tonja.ru
	w-495@tonja.ru
	w-495@yandex.ru
"""

import getopt
import sys
import os 
import os.path
	# импортируем модули обработки аргументов коммандной строки
	# возможностей операционной системы
	
class ConfigError(Exception):
	'''
		Класс ошибки конфигурации
		
		Для RSA используется косвенно,
		потому не нужно сильно вникать что сдесь происходит.
	'''
	def __init__(self, msg):
		'''
			Конструктор класса

			Вызывает конструктор родителя
		'''
		Exception.__init__(self, msg)
	
	
	
class Config:
	'''
		Конфигуратор
		
		Обрабатывает аргументы коммандной строки 
		и возвращает нужные имена.
		Для RSA используется косвенно,
		потому не нужно сильно вникать что сдесь происходит.
	'''
	
	# __INIT__
	# ******************************************************************************
	
	def __init__(
					self, 
					infileName = 'input.txt', 
					outfileName = 'code.txt', 
					checkfileName = 'obtained.txt'
				):
		'''
			Конструктор класса
			
			вычисляет и задает параметры для программы
			
			@param	self
				указательна объект, имекет тот же 
				смысл что this в С++
				
			@param	infileName
				имя файла который мы хотим зашифровать 
				
			@param	outfileName 
				 имя файла c шифром 
				 
			@param	checkfileName 
				имя файла с рассшифровкой 
		'''
		
		## Зададим строку помощи и пропишем в нее имя программы			
		self.help = USAGE % (self.__name__(),)
			
		## задает файл который мы хотим зашифровать 
		self.infileName = infileName

		## задает  файл c шифром 
		self.outfileName = outfileName

		## задает  файл с рассшифровкой 
		self.checkfileName = checkfileName
		
		## если установлен  TRUE файл c шифром будет сжат 
		self.compress = False
		
		
		self._promptArguments()
			# обработаем аргументы командной строки	
			
		
		## словарь с занчением аргументов
		self.dict = {

			'input' 	:  	self.infileName,
			'output' 	:	self.outfileName, 
			'check' 	:	self.checkfileName,
			'zip' 		: 	self.compress,

			0 :  self.infileName,
			1 :	self.outfileName, 
			2 :	self.checkfileName
			
		}
		
	# __GETITEM__
	# ******************************************************************************
	
	def __getitem__(self, key):
		'''
			Получение одного из параметров коммандной строки
		'''
		return self.dict[key]
		
	# __CALL__
	# ******************************************************************************
		
	def __call__(self, arg  = None ):
		'''
			Получить словарь с аргументами 
		'''
		
		return self.Names
		
	# __NAME__
	# ******************************************************************************
		
	def __name__(self):
		'''
			Получение короткого имени программы
			
			получаем полное имя, и обрубаем его
		'''
		
		fullname = sys.argv[0]
		namelist = fullname.split(os.sep)
		nll = len(namelist)
		name = namelist[nll-1]
		return name

	# _PROMPTARGUMENTS
	# ******************************************************************************
	
	def _promptArguments(self):
		'''
			Непосредственная обработка 
			и проверка аргументов
			
			_ пред именем указывает но то, что 
			функция закрытая
		'''
		try:
			# работает как long_getopt в С
			opts, args = getopt.getopt(
					sys.argv[1:], 
						# все аргументы начиная не с 0 а с 1 
					'i:o:c:hz',
						# короткие
					['input=', 'output=', 'check=', 'help', 'zip',]
						# длинные
				)
		except:
			raise ConfigError(self.help)

		
		for o, a in opts:
			# для всех аргументов и их параметров
			if o in ('-h', '--help'):
				print self.help
				os._exit(1)
			
			if o in ('-z', '--zip'):
				self.compress  = True
				
			if o in ('-i', '--input'):
				self.infileName = a
				
			if o in ('-o', '--output'):
				self.outfileName = a
				
			if o in ('-l', '--check'):
				self.checkfileName = a
				
		
		if ( not os.path.exists(self.infileName)):
			#  если входной файл не существует вызывем исключение
			raise ConfigError("there is no such file '%s' \n %s"%(self.infileName, self.help))
			
		## кортеж параметров
		self.Names = (self.compress, self.infileName, self.outfileName, self.checkfileName)
		
		
# TEST
# *************************************************

def test():
	'''
	 Отладочная функция

	 Отладка теста  src.config
	'''
	configurate = Config()
	print configurate()

# MAIN RUNs
# *************************************************
if (__name__ == '__main__'):
	''' 
		Выполняем в пространсве имен __main__
		Выполнится только в случае запуска этого файла
	'''
	test()
	
	
	