#! /usr/bin/env python
# -*- coding: utf-8 -*-
# TIME OF CREATION Sat May 16 21:13:19 2009

''' 
	\package   src.Rsa
	Функции работы RSA
	
	все необходимое для построение 
	системы шифрации дешифрации RSA
	здесь сильно испоьзуются функции из
	src.numericUtil и src.stringUtil
	
	\file Rsa.py
	смотрите src.Rsa
'''

from numericUtil import *
from stringUtil import *
	# импортируем все (*) из модуля src.numericUtil и src.stringUtil
	


# RSAKEYS	
# *********************************************************

def rsaKeys(size = 1024 ):
	'''
		Генерация ключей
		
		Создает открытый и закрытый ключи
		возвращает их ввиде словаря
		
		keysDict = 	{ 								\n
						'block' : size/4 - 1,		\n			
						'public': publicKey,		\n 
						'secret' : secretKey		\n
					}								\n
					
		size/4 - 1 -- размер текстового блока в символах(!)
		величина взята не с потолка, а вычисляется
		это следует из sizeInBits = log2(n),
		где n = p*q
	'''
	
	p = genPrime(size)
	q = genPrime(size)
		# генерируем два случайных простых числа
		# в size бит каждое
	
	phi = eulerPhi(p, q)
		# Вычисляется значение функция Эйлера от числа ''n'': \n
		#		$$ \varphi(n)=(p-1)(q-1) $$
	
	n = p*q
	
	i = 2
	e = None
	while(True):
		e = ferma( i )
		gcdValue = gcd(e, phi)
			# Выбирается целое число e, взаимно простое со значением функции $\varphi(n)$. 
			# Обычно в качестве ''e'' берут простые числа,  например, 
			# простые числа Ферма (		2^{2^i}+1	)
			
		i += 1
		if(abs(gcdValue) == 1):
			break
			
	d = invMod(e,phi)
			# Вычисляется число d, мультипликативно обратное 
			# к числу e по модулю phi(n)
	publicKey = (e, n)
		# двойка (кортеж) чисел
		# публикуется в качестве "открытого ключа RSA"
	secretKey = (d, n)
		# двойка (кортеж) чисел
		# играет роль "секретного ключа RSA" и держится в секрете.

	keysDict = 	{ 
					'block' : size/4 - 1, # не в байтах а в символах
					'public': publicKey, 
					'secret' : secretKey
					
					# это словарь с ключами
					# 	к нему можно будет обратиться по индексу:
					#		keysDict['block'] вернет size/4 - 1
					# 		keysDict['public'] вернет publicKey
					# 		keysDict['secret'] вернет secretKey
				}
		
	return keysDict


# ENCRYPT1	
# *********************************************************

def encrypt1(message, publicKey):
	'''
		Функция шифрования (1 блока)
		
		\param publicKey 
			двойка (кортеж) чисел (e, n)
			публикуется в качестве "открытого ключа RSA"
			
		message^e mod (n)
	'''
	
	e = publicKey[0]
	n = publicKey[1]
	#print e, n
	res = powMod(message, e, n)
	return res
	
# DECRYPT1	
# *********************************************************
	
def decrypt1(message, secretKey):
	'''
		Функция расшифровки (1 блока)
		
		\param secretKey 
			двойка чисел (d, n)
			играет роль "секретного ключа RSA" и держится в секрете.	
			
		message^d mod n
	
	'''
	
	d = secretKey[0]
	n = secretKey[1]
	
	res = powMod(message, d, n)
	return res

def encrypt(text, publicKey, blockSize = 128 ):
	'''
		Функция шифрования
		
		Переводим строку text в список блоков.
		Каддый элемент списка перегоняем в long(),
		шифруем и добавляем в список зашифрованных блоков
		
		
		\param text 
			тексткоторый хотим зашифровать
			
		\param publicKey 
			двойка (кортеж) чисел (e, n)
			публикуется в качестве "открытого ключа RSA"
			
		\param blockSize 
			размер блока шифрования
		
	'''
	resList = []
	strlist = sting2blocks(text, blockSize - 1)
	for i in strlist:
		mess = sting2long(i)
		encriptMess = encrypt1(mess, publicKey)
		resList.append(encriptMess)
	return resList
		
def decrypt(encryptList, secretKey):
	'''
		Функция расшифровки
		
		Расшифровываем каждый болк из encryptList;
		перегоняем в строку,
		полученные строки конкатенируем.
		
		\param secretKey 
			двойка чисел (d, n)
			играет роль "секретного ключа RSA" и держится в секрете.	
			
		\param encryptList 
			список зашифрованных блоков
			
	'''
	resStr = ""
	for i in encryptList:
		answer = decrypt1(i, secretKey)
		s = long2string(answer)
		resStr += s
	return resStr
	
	
import sys
	
# ======================== ========================
# TEST FUNCTION
# ======================== ========================
def test( 
			inFileName = 'input.txt', 
			outFileName = 'code.txt', 
			checkFileName = 'obtained.txt', 
		):
	'''
		Тестирование системы RSA
		
		@param	infileName
			имя файла который мы хотим зашифровать 
			
		@param	outfileName 
			 имя файла c шифром 
			 
		@param	checkfileName 
			имя файла с рассшифровкой 
		
		infile --> RSA-TEST \n
		RSA-TEST --> outfile (шифр)\n
		RSA-TEST --> checkfile (расшифровка)\n
	'''
	
	keys = rsaKeys()
		# сгенерируем ключи
	inFile = open(inFileName, 'rb')
	string = inFile.read()
		# с ввода считаем 
		# весь текст в строку
	inFile.close()
	
	encryptMess = encrypt(string,  keys['public'] , keys['block'] - 1 )
		# зашифруем текст, получим список зашифрованных блоков
		
	encryptString = encryption2string(encryptMess)
		# запишем этот список в строку
		# если мы запишем список напрямую, то
		# сильно возрастет размер зашифрованного сообщения,
		# потому что для записи
		# будет использоваться внутреннее представления списка в Python
	
	outFile	= open(outFileName, 'wb')
	outFile.write(encryptString)
		# выведем это строку на  вывод
	outFile.close()
	
	encryptMess = string2encryption(encryptString)
		# переведем строку обратно в список зашифрованных блоков
		
	decryptString = decrypt(encryptMess, keys['secret'] )
		# расшифруем список блоков, положим все в 1 строку -- это будеи мсходный текст
		
	checkFile = open(checkFileName, 'wb')	
	checkFile.write(decryptString)
		# запишем строку для контроля на  вывод ошибок
		# по завершении программы ее можно сверить с исходным текстом
	checkFile.close()
	
import zlib		

	
def testWithZip( 
					inFileName = 'input.txt', 
					outFileName = 'code.txt', 
					checkFileName = 'obtained.txt'
				):
	'''
		Тестирование системы RSA (с жатием)
		
		@param	infileName
			имя файла который мы хотим зашифровать 
			
		@param	outfileName 
			 имя файла c шифром 
			 
		@param	checkfileName 
			имя файла с рассшифровкой 
		
		infile --> RSA-TEST \n
		RSA-TEST --> outfile (шифр)\n
		RSA-TEST --> checkfile (расшифровка)\n
	'''
	
	keys = rsaKeys()
	
		# сгенерируем ключи
	inFile = open(inFileName, 'rb')
	string = inFile.read()
		# с ввода считаем 
		# весь текст в строку
	inFile.close()
	
	encryptMess = encrypt(string,  keys['public'] , keys['block'] - 1 )
		# зашифруем текст, получим список зашифрованных блоков
		
	encryptString = encryption2string(encryptMess)
		# запишем этот список в строку
		# если мы запишем список напрямую, то
		# сильно возрастет размер зашифрованного сообщения,
		# потому что для записи
		# будет использоваться внутреннее представления списка в Python
		
	encryptStringZipped = zlib.compress(encryptString)
		# для экономии места проведем компрессию строки
	
	outFile	= open(outFileName, 'wb')
	outFile.write(encryptStringZipped)
		# выведем это строку на  вывод
	outFile.close()
	
	encryptString = zlib.decompress(encryptStringZipped)
	
	encryptMess = string2encryption(encryptString)
		# переведем строку обратно в список зашифрованных блоков
		
	decryptString = decrypt(encryptMess, keys['secret'] )
		# расшифруем список блоков, положим все в 1 строку -- это будеи мсходный текст
		
	checkFile = open(checkFileName, 'wb')	
	checkFile.write(decryptString)
		# запишем строку для контроля на  вывод ошибок
		# по завершении программы ее можно сверить с исходным текстом
	checkFile.close()

# MAIN RUNs
# *************************************************
if (__name__ == '__main__'):
	''' 
		Выполняем в пространсве имен __main__
		Выполнится только в случае запуска этого файла
	'''
	
	test()

	
	
	