#! /usr/bin/env python
# -*- coding: utf-8 -*-
# TIME OF CREATION Sat May 16 21:14:11 2009


'''
	\file fw_4.py
		Основной Рабочий файл

			Его и нужно запускать 				\n
			python ./fw_4.py  [аргументы ]  	\n
			для тестирования

	\package  fw_4
		смотрите файл fw_4.py

	\author  {Илья Никитин из 08-306, по нику w495 }

	\mainpage RSA

	\section sec0 Что Нужно
	
			Требуется написать программу на c/c++ или другом обговроенном 
			языке программирования реализующую метод шифрования RSA. 
			Для сдачи лабороторной работы необходимо предоставить 
			отчет стандартного образца о сделаной работе. 
			
			Программу сдавать можно и без отчета, 
			но сроком сдачи лабораторной будет считаться срок сдачи отчета по ней.
			Описание функций самого RSA находится модуле src.Rsa (файл Rsa.py)
			Программа способна роботать без каких либо сторонних (нестандартных) модулей.
			
			Все необходимые функции были реализованы вручную.
			Однако для увелечения быстродействия желательно поставить модуль gmpy (GMP для Python)
			
			
		\section secinterface Интерфейс
		
			Программа имеет консольный интерфейс.
			При этом доступны опции коммандной строки:
			
			\li -i ИЛИ --input=		задает файл который мы хотим зашифровать 
									по умолчанию  'input.txt'
	
			\li -o ИЛИ --output=	задает  файл c шифром 
									по умолчанию  'code.txt'
									
			\li -c ИЛИ --check= 	задает  файл с рассшифровкой 
									по умолчанию   'obtained.txt' 
									
			\li -z ИЛИ --zip 		если установлен  файл c шифром будет сжат 
									по умолчанию не задан
									
			\li -h ИЛИ --help 		покажет помощь 
			
			На stdout выводятся имена файлов с шифром и с расшифрованным шифром
		
		\section sec1 Алгоритм 
		
		\subsection subsection1  Алгоритм генерации ключей
		
			\li  	Генерируем два случайных простых числа
			\li 	Вычисляем значение функция Эйлера от числа ''n'': phi(n)=(p-1)(q-1)
			\li 	Выбираем целое число e, взаимно простое со значением функции phi(n). \n
					Обычно в качестве ''e'' берут простые числа,  например, 
					простые числа Ферма \c (	2^{2^i}+1	)
			\li		Вычисляем число d, мультипликативно обратное 
					к числу e по модулю phi(n)
			\li 	\c (e, n) 	публикуется в качестве "открытого ключа RSA" \n
					\c (d, n)	играет роль "секретного ключа RSA" и держится в секрете.

		\subsection subsection21  Шифрование блока текста
		
			\li 	Переводим блок в численное представление (numIpl)
			\li 	применяем формулу numIpl^e mod n
		
		\subsection subsection22  Шифрование текста
		
			\li  	Берем открытый ключ
			\li 	Переводим текст в список блоков.
					Каждый элемент списка шифруем.
					Размер блока равен в битах логорифм двоичный от числа n.
					После не сложных выкладок можно получить, 
					что это размер в битах случайных числел (p + q) / 8
		
		\subsection subsection31  Расшифровка блока текста
		
			\li 	применяем формулу numIpl^e mod n
			\li 	Переводим блок в строковое представление
			
		\subsection subsection32  Расшифровка текста
		
			\li  	Берем закрытый ключ (если у нас он есть )) )
			\li 	Переводим шифр (строку с шифром) в список блоков.
					Каждый элемент списка дешифруем.
					
					


'''



import sys
	# импортируем модуль 
	# параметров системы
	# нужен только для аргументов командной строки
	# и прехвата исключений


import src.Rsa
	# импрортируем функции работы с RSA 
	
import src.config
	# импрортируем функции конфигурации программы 


def main():
	''' 
		основная функция
	
			def - объявление функции \n
			вся блочная структура поддерживается отступами \n
			все очень похоже на С\С++ но удобнее \n
			
			это стандартная строка документации \n
			# - комментарий \n
			## - комментарий, используемый для документации\n
	'''
	
	configuration = src.config.Config()
		## src.config.Config() возврашает объект
		## к котрому мы можем обратить как к словарю, 
		## чтобы узать входные парамерты имена файлов и наличие сжатия
		## например configuration['input'] вернет  строку с именем входного файла
	

	# ПОЛЕЗНАЯ РАБОТА
	# =====================================================================================
	if(configuration['zip']):
		# если сжатие задано, 
		# то выполним функцию c сжатием
		src.Rsa.testWithZip(
								configuration['input'],
								configuration['output'],
								configuration['check']
							)
		
	else:
		# если сжатие задано, 
		# то выполним функцию без сжатия
		src.Rsa.test(
						configuration['input'],
						configuration['output'],
						configuration['check']
					)
	# =====================================================================================
	
	print """
		The code is in '%s'
		The decripted code is in '%s'
	"""%(configuration['output'], configuration['check'])
			# тут я вывожу на экран, имена файлов с шифром 
			# и с расшифрованным шифром
			# %s как в С означает печать строки
	
	

# MAIN RUNs
# *************************************************
if (__name__ == '__main__'):
	''' 
		Выполняем в пространсве имен __main__
		только в этом файле при его запуске эта секция выполнится
	'''
	try:
		# перехват исключений
		main()
		
	except:
		# обработка исключений
		sys.stderr.write("ERROR:\n\t%s\n"%(sys.exc_info()[1]))
			# вывод ошибки stderr
			# sys.exc_info -- 	кортеж описывающий исключение
			# 					нам нужен только первый элемент
			
			
			
	
	