#include <math.h>
#include "eval.h"
#include "solvdefs.h"

char *expr;
int SolveError=0;
int CalcError=0;

VARIABLE var[]=
{
   {"x",0},
   {0}
};

double Func(double x)
{
  double result;

  var[0].value=x;
  CalcError=Evaluate(expr,var,&result);
  if (CalcError) return (0);
  return (result);
}

int Sven(double x0,double delta,double *a,double *b)
{
   double f_a,f_b,f_c,x_k=x0,x_kp;
   int k=0;

   for (;;)
   {
	  f_a=fabs(Func(x_k-fabs(delta)));
	  if (CalcError) return (CalcError);
	  f_c=fabs(Func(x_k));
	  if (CalcError) return (CalcError);
	  f_b=fabs(Func(x_k+fabs(delta)));
	  if (CalcError) return (CalcError);
	  if ((f_a<f_c)&&(f_c<f_b)) delta=-fabs(delta);
	  if ((f_a>f_c)&&(f_c>f_b)) delta=fabs(delta);
	  if ((f_a<f_c)&&(f_c>f_b)) return (slv_FUNC);
	  x_kp=x_k;
	  x_k=x_kp+delta*pow(2,(double)k);
	  if ((fabs(x_k)<=1e-300)||(fabs(x_k)>=1e300)) return (slv_RANGE);
	  f_a=fabs(Func(x_k));
	  if (CalcError) return (CalcError);
	  if ((f_a>f_c)&&(f_c<f_b)) break;
	  k++;
   }
   if (x_kp<x_k) {*a=x_kp;*b=x_k;}
   else {*a=x_k;*b=x_kp;}
   return (slv_OK);
}

int Fibon(double a,double b,double eps,double *root)
{
   double fib1=1,fib2=1,c1=0,c2=1,swp;
   double y,z,f_y,f_z;

   while (fabs(c2-c1)>=eps)
   {
	  swp=fib2;
	  fib2+=fib1;
	  fib1=swp;
	  c1=c2;
	  c2=fib1/fib2;
   }
   y=b-c2*(b-a);
   z=a+c2*(b-a);
   f_y=fabs(Func(y));
   if (CalcError) return (CalcError);
   f_z=fabs(Func(z));
   if (CalcError) return (CalcError);
   while (fabs(b-a)>=eps)
   {
	  if (f_y<f_z)
	  {
	 b=z;
	 z=y;
	 f_z=f_y;
	 y=b-c2*(b-a);
	 f_y=fabs(Func(y));
	 if (CalcError) return (CalcError);
	  }
	  else
	  {
	 a=y;
	 y=z;
	 f_y=f_z;
	 z=a+c2*(b-a);
	 f_z=fabs(Func(z));
	 if (CalcError) return (CalcError);
	  }
   }
   *root=(a+b)/2;
   return (slv_OK);
}

int Solve(char *func,double x0,double eps,double *result)
{
   double a,b;
   expr=func;
   if ((SolveError=Sven(x0,eps,&a,&b))!=slv_OK) return (SolveError);
   if ((SolveError=Fibon(a,b,eps,result))!=slv_OK) return (SolveError);
   if (((Func(*result-eps)<=0)&&(Func(*result+eps)>=0))\
	  ||((Func(*result-eps)>=0)&&(Func(*result+eps)<=0))\
	  ||(fabs(Func(*result)))<sqrt(eps)) return (slv_OK);
   else return (slv_ROOT);
}

