// PolyhedronAction.cpp : implementation file
//

#include "stdafx.h"
#include "Polyhedron.h"
#include "PolyhedronAction.h"

//  OpenGL
#include "gl\gl.h"
#include "gl\glu.h"
#include "gl\glaux.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronAction

CPolyhedronAction::CPolyhedronAction()
{
}

CPolyhedronAction::~CPolyhedronAction()
{
}

//Rendering setup
void CPolyhedronAction::DefineMaterialf(float mat_emitter[4], float mat_specular[4],
										float icosahedron_diffuse[4], float specular_exponent)
{
    glMaterialfv(GL_FRONT, GL_EMISSION, mat_emitter);
    glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
    glMaterialf(GL_FRONT, GL_SHININESS, specular_exponent);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, icosahedron_diffuse);
}

void CPolyhedronAction::Create(int m_Polyhedron, bool m_Wired)
{
		// *** :    ,   
	switch (m_Polyhedron)
	{
		case 1 : 
			{
				if (m_Wired)
					auxWireTetrahedron(1.0f);
				else
					auxSolidTetrahedron(1.0f);
				break;
			}
		case 2 : 
			{
				if (m_Wired)
					auxWireCube(1.0f);
				else
					auxSolidCube(1.0f);
				break;
			}
		case 3 :
			{
				if (m_Wired)
					auxWireOctahedron(1.0f);
				else
					auxSolidOctahedron(1.0f);
				break;
			}
		case 4 : 
			{
				if (m_Wired)
					auxWireDodecahedron(1.0f);
				else
					auxSolidDodecahedron(1.0f);
				break;
			}
		case 5 :
			{
				if (m_Wired)
					auxWireIcosahedron(1.0f);
				else
					auxSolidIcosahedron(1.0f);
				break;
			}
	}

}

void CPolyhedronAction::Movement(bool m_Dir, int m_Dispos,
							float m_CameraDistance, float m_Dist)
{
	wAngle=abs(wAngle)*(2*m_Dir-1);
	//,      
	glTranslatef(0.0f, 0.0f, -m_CameraDistance/10);
	// 

	/// ***** 
		switch (m_Dispos)
		{
		case 0:
			{
				glRotatef(wAngle, 1.0f, 0.0f, 0.0f);
				glTranslatef(0.0f, m_Dist/10, 0.0f);
				break;
			}
		case 1:
			{
				glRotatef(wAngle, 0.0f, 1.0f, 0.0f);
				glTranslatef(m_Dist/10, 0.0f, 0.0f);
				break;
			}
		case 2:
			{
				glRotatef(wAngle, 0.0f, 0.0f, 1.0f);
				glTranslatef(0.0f, m_Dist/10, 0.0f);
				break;
			}
		}

		wAngle += 3.0f*(2*m_Dir-1);
		return;
};