#include "stdafx.h"
#include "../main.h"
#include "CStationForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	CString IsEmpty_CEdit(CEdit* ctrl);
	void sqlFilter(CString* value);
	bool isUnique(CString sql,CString fields);
	bool isRelate(CString sql,CString fields);

CStationForm::CStationForm(CWnd* pParent):CDialog(CStationForm::IDD,pParent){
  //{{AFX_DATA_INIT(CStationForm)
  //}}AFX_DATA_INIT
	}

void CStationForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CStationForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CStationForm, CDialog)
  //{{AFX_MSG_MAP(CStationForm)
	ON_BN_CLICKED(Button_AddStation, AddStation_onClick)
	ON_BN_CLICKED(Button_EditStation, EditStation_onClick)
	ON_BN_CLICKED(Button_DeleteStation, DeleteStation_onClick)
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pList_Station;
	CEdit* pEdit_station;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pList_Station_indexes;
	int* pLSiLen;

void ClearIndexes_pList_Station_indexes(){
	if(pList_Station_indexes){
		delete []pList_Station_indexes,pLSiLen;
		pList_Station_indexes=pLSiLen=NULL;}}

void InitIndexes_pList_Station_indexes(int len){
	pList_Station_indexes=new int[len];
   *(pLSiLen=new int)=len;}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void Load_List_Station(){
	pList_Station->ResetContent();
	RS=new CMyRecordset(&DB);
	RS->Open("SELECT * FROM Station ORDER BY name","[station_ID]&,[name]$");
	RS->DefineRealCount();
	if(RS->Count){
		InitIndexes_pList_Station_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pList_Station_indexes[i]=RS->fieldsValue[0].m_lVal;
			pList_Station->InsertString(i,RS->fieldsValue[1].m_cstring);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

void setCurSel_StationForm(int fictionIndex){
	for(int i=0;i<*pLSiLen;i++)
		if(pList_Station_indexes[i]==fictionIndex){
			pList_Station->SetCurSel(i);
			return;}}

bool IsSelected_StationForm(){
	if(pList_Station->GetCurSel()==-1){
		AfxMessageBox("Nothing selected!");
		return 0;}
	return 1;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void CStationForm::AddStation_onClick(){
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_station))=="") return;
	sqlFilter(&newValue);
 // >>>
	CString prepSql="SELECT name From Station WHERE name='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[name]$"))return;
 // >>>
	CString insertSql="INSERT INTO Station (name) Values('$$$')";
			insertSql.Replace("$$$",newValue);
	DB.ExecuteSQL(insertSql);
	Load_List_Station();
	pEdit_station->SetWindowText("");
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT station_ID From Station WHERE name='$$$'";
			getNewIdSql.Replace("$$$",newValue);
		RS->Open(getNewIdSql,"[station_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_StationForm(newId);}

void CStationForm::EditStation_onClick(){	
	if(!IsSelected_StationForm())return;
	int cID=pList_Station_indexes[pList_Station->GetCurSel()];
 // >>>
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_station))=="") return;
	sqlFilter(&newValue);
 // >>>
    CString prepSql="SELECT name From Station WHERE name='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[name]$"))return;
 // >>>
	CString updateSql="UPDATE Station SET Station.name = '$$1' WHERE station_ID=$$2";
			updateSql.Replace("$$1",newValue);
			updateSql.Replace("$$2",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_List_Station();
	pEdit_station->SetWindowText("");
 // :::
	setCurSel_StationForm(cID);}

void CStationForm::DeleteStation_onClick(){
	if(!IsSelected_StationForm())return;
	int cID=pList_Station_indexes[pList_Station->GetCurSel()];
 // >>>
	CString relateTestSql="SELECT path_ID FROM path WHERE [start/end station_ID]=$$$ OR [end/start station_ID]=$$$";
			relateTestSql.Replace("$$$",toString(cID));
	if(isRelate(relateTestSql,"[station_ID]&"))return;
 // >>>
	CString deleteSql="DELETE * FROM Station WHERE station_ID=";
			deleteSql+=toString(cID);
	DB.ExecuteSQL(deleteSql);
	int oldSel=pList_Station->GetCurSel();
	Load_List_Station();
 // :::
	pList_Station->SetCurSel(oldSel>pList_Station->GetCount()-1?pList_Station->GetCount()-1:oldSel);}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CStationForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CStationForm::OnInitDialog(){CDialog::OnInitDialog();
 // >>>
	pList_Station=(CListBox*)GetDlgItem(List_Station);
	pEdit_station=(CEdit*)GetDlgItem(Edit_station);
 // >>>
	Load_List_Station();
	return TRUE;}

void CStationForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pList_Station_indexes();}
