#include "stdafx.h"
#include "../main.h"
#include "CRaceForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	CString IsEmpty_CEdit(CEdit* ctrl);
	void sqlFilter(CString* value);
	bool isUnique(CString sql,CString fields);
	bool isRelate(CString sql,CString fields);
	void Load_List(CString sql,CString fields,CListBox* ctrl,void clearIdxFunc(void),void initIdxFunc(int),void setIdxFunc(int,int));

CRaceForm::CRaceForm(CWnd* pParent):CDialog(CRaceForm::IDD,pParent){
  //{{AFX_DATA_INIT(CRaceForm)
  //}}AFX_DATA_INIT
	}

void CRaceForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CRaceForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CRaceForm, CDialog)
	//{{AFX_MSG_MAP(CRaceForm)
	ON_BN_CLICKED(Button_AddRace, AddRace_onClick)
	ON_BN_CLICKED(Button_EditRace, EditRace_onClick)
	ON_BN_CLICKED(Button_DeleteRace, DeleteRace_onClick)
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_WM_CLOSE()
	ON_BN_CLICKED(Button_toAcceptPath, toAcceptPath_onCLick)
	ON_BN_CLICKED(Button_toFreePath, toFreePath_onClick)
	ON_LBN_SELCHANGE(Race_List, SelchangeList_onSelectChange)
	ON_LBN_SELCHANGE(List_AcceptPath, AcceptPath_onSelchange)
	ON_LBN_SELCHANGE(List_FreePath, FreePath_onSelchange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pRace_List;
	CEdit* pEdit_race;

	CListBox* pList_AcceptPath;
	CListBox* pList_FreePath;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pRace_List_indexes;
	int* pRLiLen;

void ClearIndexes_pRace_List_indexes(){
	if(pRace_List_indexes){
		delete []pRace_List_indexes,pRLiLen;
		pRace_List_indexes=pRLiLen=NULL;}}

void InitIndexes_pRace_List_indexes(int len){
	pRace_List_indexes=new int[len];
   *(pRLiLen=new int)=len;}

	int* pList_AcceptPath_indexes;
	int* pLAPiLen;

void ClearIndexes_pList_AcceptPath_indexes(){
	if(pList_AcceptPath_indexes){
		delete []pList_AcceptPath_indexes,pLAPiLen;
		pList_AcceptPath_indexes=pLAPiLen=NULL;}}

void InitIndexes_pList_AcceptPath_indexes(int len){
	pList_AcceptPath_indexes=new int[len];
   *(pLAPiLen=new int)=len;}

void SetIndexes_pList_AcceptPath_indexes(int idx,int value){
	pList_AcceptPath_indexes[idx]=value;}

	int* pList_FreePath_indexes;
	int* pLFPiLen;

void ClearIndexes_pList_FreePath_indexes(){
	if(pList_FreePath_indexes){
		delete []pList_FreePath_indexes,pLFPiLen;
		pList_FreePath_indexes=pLFPiLen=NULL;}}

void InitIndexes_pList_FreePath_indexes(int len){
	pList_FreePath_indexes=new int[len];
   *(pLFPiLen=new int)=len;}

void SetIndexes_pList_FreePath_indexes(int idx,int value){
	pList_FreePath_indexes[idx]=value;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void Load_Race_List(){
	pRace_List->ResetContent();
	RS=new CMyRecordset(&DB);
	RS->Open("SELECT Race.race_ID, Str(Race.race_ID)+') '+Race.description FROM Race ORDER BY Race.description","[race_ID]&,[Expr1001]$");
	RS->DefineRealCount();
	ClearIndexes_pRace_List_indexes();
	if(RS->Count){
		InitIndexes_pRace_List_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pRace_List_indexes[i]=RS->fieldsValue[0].m_lVal;
			pRace_List->InsertString(i,RS->fieldsValue[1].m_cstring);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

bool IsSelected_Race_List(){
	if(pRace_List->GetCurSel()==-1){
		AfxMessageBox("Nothing selected!");
		return 0;}
	return 1;}

void setCurSel_Race_List(int fictionIndex){
	for(int i=0;i<*pRLiLen;i++)
		if(pRace_List_indexes[i]==fictionIndex){
			pRace_List->SetCurSel(i);
			return;}}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void CRaceForm::AddRace_onClick(){
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_race))=="") return;
	sqlFilter(&newValue);
 // >>>
	CString prepSql="SELECT Race.race_ID FROM Race WHERE Race.description='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[race_ID]&"))return;	
 // >>>
	CString insertSql="INSERT INTO Race (description) Values('$$$')";
			insertSql.Replace("$$$",newValue);
	DB.ExecuteSQL(insertSql);
	Load_Race_List();
	pEdit_race->SetWindowText("");
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT Race.race_ID FROM Race WHERE Race.description='$$1'";
			getNewIdSql.Replace("$$1",newValue);
		RS->Open(getNewIdSql,"[race_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_Race_List(newId);
	this->SelchangeList_onSelectChange();}

void CRaceForm::EditRace_onClick(){	
	if(!IsSelected_Race_List())return;
	long cID=pRace_List_indexes[pRace_List->GetCurSel()];
 // >>>
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_race))=="") return;
	sqlFilter(&newValue);
 // >>>
	CString prepSql="SELECT Race.race_ID FROM Race WHERE Race.description='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[race_ID]&"))return;	
 // >>>
	CString updateSql="UPDATE Race SET Race.description='$$1' WHERE Race.race_ID=$$2";
			updateSql.Replace("$$1",newValue);
			updateSql.Replace("$$2",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_Race_List();
	pEdit_race->SetWindowText("");
	setCurSel_Race_List(cID);}

void CRaceForm::DeleteRace_onClick(){	
	if(!IsSelected_Race_List())return;
	long cID=pRace_List_indexes[pRace_List->GetCurSel()];
 // >>>
	CString relateTestSql="SELECT Bus.bus_ID FROM Bus WHERE Bus.race_ID=$$$";
			relateTestSql.Replace("$$$",toString(cID));
	if(isRelate(relateTestSql,"[bus_ID]&"))return;
 // >>>
	CString deleteSql="DELETE Race.* FROM Race WHERE Race.race_ID=$$$";
			deleteSql.Replace("$$$",toString(cID));
	DB.ExecuteSQL(deleteSql);
	long oldSel=pRace_List->GetCurSel();
	Load_Race_List();
	pRace_List->SetCurSel(oldSel>pRace_List->GetCount()-1?pRace_List->GetCount()-1:oldSel);
	this->SelchangeList_onSelectChange();}

/* ============================ 
   ======= Accept pathes ====== 
   ============================ */

void CRaceForm::AcceptPath_onSelchange(){pList_FreePath->SetCurSel(-1);}
void CRaceForm::FreePath_onSelchange(){pList_AcceptPath->SetCurSel(-1);}

CString sh1Sql="SELECT Path.path_ID, Station_1.name+' < - > '+Station_2.name FROM Station AS Station_2 INNER JOIN ((Station AS Station_1 INNER JOIN PAth ON Station_1.station_ID = PAth.[start/end station_ID]) INNER JOIN [Race items] ON Path.path_ID = [Race items].path_ID) ON Station_2.station_ID = Path.[end/start station_ID] WHERE [Race items].race_ID = $$1 ORDER BY Station_1.name+' < - > '+Station_2.name";
CString sh2Sql="SELECT PAth.path_ID, Station_1.name+' < - > '+Station_2.name FROM Station AS Station_2 INNER JOIN ((Station AS Station_1 INNER JOIN PAth ON Station_1.station_ID = PAth.[start/end station_ID]) LEFT  JOIN [Race items] ON PAth.path_ID = [Race items].path_ID) ON Station_2.station_ID = PAth.[end/start station_ID] WHERE [Race items].race_ID <> $$1 Or [Race items].race_ID Is Null ORDER BY Station_1.name+' < - > '+Station_2.name";

void Load_List_AcceptPath(long cID){
	CString tmpSql(sh1Sql);
			tmpSql.Replace("$$1",toString(cID));
	Load_List(tmpSql,"[path_ID]&,[Expr1001]$",pList_AcceptPath,ClearIndexes_pList_AcceptPath_indexes,InitIndexes_pList_AcceptPath_indexes,SetIndexes_pList_AcceptPath_indexes);}

void Load_List_FreePath(long cID){
	CString tmpSql(sh2Sql);
			tmpSql.Replace("$$1",toString(cID));
	Load_List(tmpSql,"[path_ID]&,[Expr1001]$",pList_FreePath,ClearIndexes_pList_FreePath_indexes,InitIndexes_pList_FreePath_indexes,SetIndexes_pList_FreePath_indexes);}

void CRaceForm::toAcceptPath_onCLick(){
	long cFictionID=pList_FreePath->GetCurSel();
 // ===
	if(cFictionID==-1){
		AfxMessageBox("Nothing selected!");
		return;}
 // >>>
	CString prepSql="INSERT INTO [Race items] (race_ID,path_ID) Values($$1,$$2)";
			prepSql.Replace("$$1",toString(pRace_List_indexes[pRace_List->GetCurSel()]));
			prepSql.Replace("$$2",toString(pList_FreePath_indexes[cFictionID]));
	DB.ExecuteSQL(prepSql);
 // >>>
	long cRaceID=pRace_List_indexes[pRace_List->GetCurSel()];
	Load_List_AcceptPath(cRaceID);
	Load_List_FreePath(cRaceID);}

void CRaceForm::toFreePath_onClick(){
	long cFictionID=pList_AcceptPath->GetCurSel();
 // ===
	if(cFictionID==-1){
		AfxMessageBox("Nothing selected!");
		return;}
 // >>>
	CString prepSql="DELETE [Race items].* FROM [Race items] WHERE [Race items].path_ID=$$$";
			prepSql.Replace("$$$",toString(pList_AcceptPath_indexes[cFictionID]));
	DB.ExecuteSQL(prepSql);
 // >>>
	long cRaceID=pRace_List_indexes[pRace_List->GetCurSel()];
	Load_List_AcceptPath(cRaceID);
	Load_List_FreePath(cRaceID);}

void CRaceForm::SelchangeList_onSelectChange(){
	if(pRace_List->GetCurSel()==-1)return;
	long cID=pRace_List_indexes[pRace_List->GetCurSel()];
 // >>>
	Load_List_AcceptPath(cID);
	Load_List_FreePath(cID);}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CRaceForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CRaceForm::OnInitDialog(){CDialog::OnInitDialog();
// >>>
	pRace_List=(CListBox*)GetDlgItem(Race_List);
	pEdit_race=(CEdit*)GetDlgItem(Edit_race);
 // ===
	pList_AcceptPath=(CListBox*)GetDlgItem(List_AcceptPath);
	pList_FreePath=(CListBox*)GetDlgItem(List_FreePath);
 // >>>
	Load_Race_List();
 // >>>
	return TRUE;}

void CRaceForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pRace_List_indexes();
	ClearIndexes_pList_AcceptPath_indexes();
	ClearIndexes_pList_FreePath_indexes();}

