#include "stdafx.h"
#include "../main.h"
#include "CBusForm.h"
#include "CTypeForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	CString IsEmpty_CEdit(CEdit* ctrl);
	void sqlFilter(CString* value);
	bool isUnique(CString sql,CString fields);
	bool isRelate(CString sql,CString fields);
	void Load_List(CString sql,CString fields,CListBox* ctrl,void clearIdxFunc(void),void initIdxFunc(int),void setIdxFunc(int,int));
	void Load_List(CString sql,CString fields,CComboBox* ctrl,void clearIdxFunc(void),void initIdxFunc(int),void setIdxFunc(int,int));

CBusForm::CBusForm(CWnd* pParent):CDialog(CBusForm::IDD, pParent){
  //{{AFX_DATA_INIT(CBusForm)
  //}}AFX_DATA_INIT
	}

void CBusForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CBusForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CBusForm, CDialog)
  //{{AFX_MSG_MAP(CBusForm)
	ON_BN_CLICKED(Button_showBusType, showBusType_onClick)
	ON_BN_CLICKED(Button_DeleteBus, DeleteBus_onClick)
	ON_BN_CLICKED(Button_EditBus, EditBus_onClick)
	ON_BN_CLICKED(Button_AddBus, AddBus_onClick)
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pList_Bus;
	CComboBox* pComboBox_BusType;
	CComboBox* pComboBox_RaceInBus;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pList_Bus_indexes;
	int* pLBiLen;

void ClearIndexes_pList_Bus_indexes(){
	if(pList_Bus_indexes){
		delete []pList_Bus_indexes,pLBiLen;
		pList_Bus_indexes=pLBiLen=NULL;}}

void InitIndexes_pList_Bus_indexes(int len){
	pList_Bus_indexes=new int[len];
   *(pLBiLen=new int)=len;}

void SetIndexes_pList_Bus_indexes(int idx,int value){
	pList_Bus_indexes[idx]=value;}

	int* pComboBox_BusType_indexes;
	int* pCBBTiLen;

void ClearIndexes_pComboBox_BusType_indexes(){
	if(pComboBox_BusType_indexes){
		delete []pComboBox_BusType_indexes,pCBBTiLen;
		pComboBox_BusType_indexes=pCBBTiLen=NULL;}}

void InitIndexes_pComboBox_BusType_indexes(int len){
	pComboBox_BusType_indexes=new int[len];
   *(pCBBTiLen=new int)=len;}

void SetIndexes_pComboBox_BusType_indexes(int idx,int value){
	pComboBox_BusType_indexes[idx]=value;}

	int* pComboBox_RaceInBus_indexes;
	int* pCBRIBiLen;

void ClearIndexes_pComboBox_RaceInBus_indexes(){
	if(pComboBox_RaceInBus_indexes){
		delete []pComboBox_RaceInBus_indexes,pCBRIBiLen;
		pComboBox_RaceInBus_indexes=pCBRIBiLen=NULL;}}

void InitIndexes_pComboBox_RaceInBus_indexes(int len){
	pComboBox_RaceInBus_indexes=new int[len];
   *(pCBRIBiLen=new int)=len;}

void SetIndexes_pComboBox_RaceInBus_indexes(int idx,int value){
	pComboBox_RaceInBus_indexes[idx]=value;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void Load_List_Bus(){
	Load_List("SELECT Bus.bus_ID,Trim(Str(Bus.bus_ID))+') '+Race.description+' - '+Type.name FROM Type INNER JOIN (Race INNER JOIN Bus ON Race.race_ID = Bus.race_ID) ON Type.busType_ID = Bus.busType_ID ORDER BY Trim(Str(Bus.bus_ID))+') '+Race.description+' - '+Type.name","[bus_ID]&,[Expr1001]$",
				pList_Bus,
				ClearIndexes_pList_Bus_indexes,
				InitIndexes_pList_Bus_indexes,
				SetIndexes_pList_Bus_indexes);}

void Load_ComboBox_BusType(){
	Load_List("SELECT Type.* FROM Type","[busType_ID]&,[name]$",
				pComboBox_BusType,
				ClearIndexes_pComboBox_BusType_indexes,
				InitIndexes_pComboBox_BusType_indexes,
				SetIndexes_pComboBox_BusType_indexes);}

void Load_ComboBox_RaceInBus(){
	Load_List("SELECT Race.race_ID,Trim(Str(Race.race_ID))+') '+Race.description FROM Race","[race_ID]&,[Expr1001]$",
				pComboBox_RaceInBus,
				ClearIndexes_pComboBox_RaceInBus_indexes,
				InitIndexes_pComboBox_RaceInBus_indexes,
				SetIndexes_pComboBox_RaceInBus_indexes);}

bool IsSelected_BusForm(){
	if(pComboBox_BusType->GetCurSel()==-1||
	   pComboBox_RaceInBus->GetCurSel()==-1){
			AfxMessageBox("Nothing selected!");
			return 0;}
	return 1;}

bool IsSelected_List_Bus(){
	if(pList_Bus->GetCurSel()==-1){
			AfxMessageBox("Nothing selected!");
			return 0;}
	return 1;}

void setCurSel_List_Bus(int fictionIndex){
	for(int i=0;i<*pLBiLen;i++)
		if(pList_Bus_indexes[i]==fictionIndex){
			pList_Bus->SetCurSel(i);
			return;}}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void CBusForm::AddBus_onClick(){
	if(!IsSelected_BusForm())return;
 // >>>
	long bysType=pComboBox_BusType_indexes[pComboBox_BusType->GetCurSel()];
	long raceInBus=pComboBox_RaceInBus_indexes[pComboBox_RaceInBus->GetCurSel()];
 // >>>
	CString insertSql="INSERT INTO Bus (busType_ID,race_ID) Values($$1,$$2)";
			insertSql.Replace("$$1",toString(bysType));
			insertSql.Replace("$$2",toString(raceInBus));
	DB.ExecuteSQL(insertSql);
	Load_List_Bus();
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT TOP 1 Bus.bus_ID FROM Bus WHERE Bus.busType_ID=$$1 AND Bus.race_ID=$$2 ORDER BY Bus.bus_ID DESC";
			getNewIdSql.Replace("$$1",toString(bysType));
			getNewIdSql.Replace("$$2",toString(raceInBus));
		RS->Open(getNewIdSql,"[bus_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_List_Bus(newId);}

void CBusForm::EditBus_onClick(){
	if(!IsSelected_List_Bus())return;
	if(!IsSelected_BusForm())return;
 // >>>
	long cID=pList_Bus_indexes[pList_Bus->GetCurSel()];
	long bysType=pComboBox_BusType_indexes[pComboBox_BusType->GetCurSel()];
	long raceInBus=pComboBox_RaceInBus_indexes[pComboBox_RaceInBus->GetCurSel()];
 // >>>
	CString updateSql="UPDATE Bus SET Bus.busType_ID=$$1,Bus.race_ID=$$2 WHERE Bus.bus_ID=$$3";
			updateSql.Replace("$$1",toString(bysType));
			updateSql.Replace("$$2",toString(raceInBus));
			updateSql.Replace("$$3",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_List_Bus();
	setCurSel_List_Bus(cID);}

void CBusForm::DeleteBus_onClick(){
	if(!IsSelected_List_Bus())return;
 // >>>
	long cID=pList_Bus_indexes[pList_Bus->GetCurSel()];
 // >>>
	CString deleteSql="DELETE Bus.*, Bus.bus_ID FROM Bus WHERE Bus.bus_ID=$$$";
			deleteSql.Replace("$$$",toString(cID));
	DB.ExecuteSQL(deleteSql);
	long oldSel=pList_Bus->GetCurSel();
	Load_List_Bus();
// :::
	pList_Bus->SetCurSel(oldSel>pList_Bus->GetCount()-1?pList_Bus->GetCount()-1:oldSel);}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CBusForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CBusForm::OnInitDialog(){CDialog::OnInitDialog();
 // >>>
	pList_Bus=(CListBox*)GetDlgItem(List_Bus);
	pComboBox_BusType=(CComboBox*)GetDlgItem(ComboBox_BusType);
	pComboBox_RaceInBus=(CComboBox*)GetDlgItem(ComboBox_RaceInBus);
 // >>>
	Load_List_Bus();
	Load_ComboBox_BusType();
	Load_ComboBox_RaceInBus();
 // >>>
	return TRUE;}

void CBusForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pList_Bus_indexes();
	ClearIndexes_pComboBox_BusType_indexes();
	ClearIndexes_pComboBox_RaceInBus_indexes();}

void CBusForm::showBusType_onClick(){
	CTypeForm typeForm;
	typeForm.DoModal();
	Load_ComboBox_BusType();}
