#include "stdafx.h"
#include "../main.h"
#include "CTypeForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	CString IsEmpty_CEdit(CEdit* ctrl);
	void sqlFilter(CString* value);
	bool isUnique(CString sql,CString fields);
	bool isRelate(CString sql,CString fields);

CTypeForm::CTypeForm(CWnd* pParent):CDialog(CTypeForm::IDD,pParent){
  //{{AFX_DATA_INIT(CTypeForm)
  //}}AFX_DATA_INIT
	}

void CTypeForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CTypeForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CTypeForm, CDialog)
  //{{AFX_MSG_MAP(CTypeForm)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_BN_CLICKED(Button_AddBusType, AddBusType_onClick)
	ON_BN_CLICKED(Button_EditBusType, EditBusType_onClick)
	ON_BN_CLICKED(Button_DeleteBusType, DeleteBusType_onClick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pList_BusType;
	CEdit* pEdit_busType;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pList_BusType_indexes;
	int* pLBTiLen;

void ClearIndexes_pList_BusType_indexes(){
	if(pList_BusType_indexes){
		delete []pList_BusType_indexes,pLBTiLen;
		pList_BusType_indexes=pLBTiLen=NULL;}}

void InitIndexes_pList_BusType_indexes(int len){
	pList_BusType_indexes=new int[len];
   *(pLBTiLen=new int)=len;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void Load_List_BusType(){
	pList_BusType->ResetContent();
	RS=new CMyRecordset(&DB);
	RS->Open("SELECT * FROM Type ORDER BY name","[busType_ID]&,[name]$");
	RS->DefineRealCount();
	ClearIndexes_pList_BusType_indexes();
	if(RS->Count){
		InitIndexes_pList_BusType_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pList_BusType_indexes[i]=RS->fieldsValue[0].m_lVal;
			pList_BusType->InsertString(i,RS->fieldsValue[1].m_cstring);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

void setCurSel_TypeForm(int fictionIndex){
	for(int i=0;i<*pLBTiLen;i++)
		if(pList_BusType_indexes[i]==fictionIndex){
			pList_BusType->SetCurSel(i);
			return;}}

bool IsSelected_TypeForm(){
	if(pList_BusType->GetCurSel()==-1){
		AfxMessageBox("Nothing selected!");
		return 0;}
	return 1;}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void CTypeForm::AddBusType_onClick(){
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_busType))=="") return;
	sqlFilter(&newValue);
 // >>>
	CString prepSql="SELECT name From Type WHERE name='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[name]$"))return;
 // >>>
	CString insertSql="INSERT INTO Type (name) Values('$$$')";
			insertSql.Replace("$$$",newValue);
	DB.ExecuteSQL(insertSql);
	Load_List_BusType();
	pEdit_busType->SetWindowText("");
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT busType_ID From Type WHERE name='$$$'";
			getNewIdSql.Replace("$$$",newValue);
		RS->Open(getNewIdSql,"[busType_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_TypeForm(newId);}

void CTypeForm::EditBusType_onClick(){
	if(!IsSelected_TypeForm())return;
	int cID=pList_BusType_indexes[pList_BusType->GetCurSel()];
 // >>>
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_busType))=="") return;
	sqlFilter(&newValue);
 // >>>
	CString prepSql="SELECT name From Type WHERE name='$$$'";
			prepSql.Replace("$$$",newValue);
	if(!isUnique(prepSql,"[name]$"))return;
 // >>>
	CString updateSql="UPDATE Type SET Type.name = '$$1' WHERE busType_ID=$$2";
			updateSql.Replace("$$1",newValue);
			updateSql.Replace("$$2",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_List_BusType();
	pEdit_busType->SetWindowText("");
 // :::
	setCurSel_TypeForm(cID);}

void CTypeForm::DeleteBusType_onClick(){
	if(!IsSelected_TypeForm())return;
	int cID=pList_BusType_indexes[pList_BusType->GetCurSel()];
 // >>>
 // >>>
	CString relateTestSql="SELECT bus_ID FROM Bus WHERE busType_ID=$$$";
			relateTestSql.Replace("$$$",toString(cID));
	if(isRelate(relateTestSql,"[bus_ID]&"))return;
 // >>>
	CString deleteSql="DELETE * FROM Type WHERE busType_ID=";
			deleteSql+=toString(cID);
	DB.ExecuteSQL(deleteSql);
	int oldSel=pList_BusType->GetCurSel();
	Load_List_BusType();
 // :::
	pList_BusType->SetCurSel(oldSel>pList_BusType->GetCount()-1?pList_BusType->GetCount()-1:oldSel);}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CTypeForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CTypeForm::OnInitDialog(){CDialog::OnInitDialog();
 // >>>
	pList_BusType=(CListBox*)GetDlgItem(List_BusType);
	pEdit_busType=(CEdit*)GetDlgItem(Edit_busType);
 // >>>
	Load_List_BusType();
	return TRUE;}

void CTypeForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pList_BusType_indexes();}
