#include "stdafx.h"
#include "../main.h"
#include "CTimeForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	bool isUnique(CString sql,CString fields);

CTimeForm::CTimeForm(CWnd* pParent):CDialog(CTimeForm::IDD,pParent){
  //{{AFX_DATA_INIT(CTimeForm)
  //}}AFX_DATA_INIT
	}

void CTimeForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CTimeForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CTimeForm, CDialog)
  //{{AFX_MSG_MAP(CTimeForm)
	ON_BN_CLICKED(Button_timesHelp, timesHelp_onClick)
	ON_BN_CLICKED(Button_AddTime, AddTime_onClick)
	ON_BN_CLICKED(Button_EditTime, EditTime_onClick)
	ON_BN_CLICKED(Button_DeleteTime, DeleteTime_onClick)
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(ComboBox_BusList, SelchangeBusList_onChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pList_Time;
	CComboBox* pComboBox_BusList;
	CComboBox* pComboBox_TimeH;
	CComboBox* pComboBox_TimeM;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pList_Time_indexes;
	int* pLTiLen;

void ClearIndexes_pList_Time_indexes(){
	if(pList_Time_indexes){
		delete []pList_Time_indexes,pLTiLen;
		pList_Time_indexes=pLTiLen=NULL;}}

void InitIndexes_pList_Time_indexes(int len){
	pList_Time_indexes=new int[len];
   *(pLTiLen=new int)=len;}

	int* pComboBox_BusList_indexes;
	int* pCBBiLen;

void ClearIndexes_pComboBox_BusList_indexes(){
	if(pComboBox_BusList_indexes){
		delete []pComboBox_BusList_indexes,pLTiLen;
		pComboBox_BusList_indexes=pCBBiLen=NULL;}}

void InitIndexes_pComboBox_BusList_indexes(int len){
	pComboBox_BusList_indexes=new int[len];
   *(pCBBiLen=new int)=len;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void Load_List_Time(int busID){
	pList_Time->ResetContent();
	RS=new CMyRecordset(&DB);
	CString selectSql="SELECT Time.time_ID,Time.time FROM [Time] WHERE Time.bus_ID=$$$ ORDER BY Time.time;"; selectSql.Replace("$$$",toString(busID));
	RS->Open(selectSql,"[time_ID]&,[time]&");
	RS->DefineRealCount();
	ClearIndexes_pList_Time_indexes();
	if(RS->Count){
		InitIndexes_pList_Time_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pList_Time_indexes[i]=RS->fieldsValue[0].m_lVal;
			CString Time,buf1,buf2;
				buf1+="0"; buf1+=toString((int)RS->fieldsValue[1].m_lVal/60);
				buf2+="0"; buf2+=toString((int)RS->fieldsValue[1].m_lVal%60);
				Time+=buf1.Right(2); Time+=":";
				Time+=buf2.Right(2);
			pList_Time->InsertString(i,Time);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

void Load_ComboBox_BusList(){
	pComboBox_BusList->ResetContent();
	RS=new CMyRecordset(&DB);
	CString selectSql="SELECT Bus.bus_ID,Type.name,Race.description FROM Race INNER JOIN (Type INNER JOIN Bus ON Type.busType_ID = Bus.busType_ID) ON Race.race_ID = Bus.race_ID ORDER BY Type.name,Race.description";
	RS->Open(selectSql,"[bus_ID]&,[name]$,[description]$");
	RS->DefineRealCount();
	ClearIndexes_pComboBox_BusList_indexes();
	if(RS->Count){
		InitIndexes_pComboBox_BusList_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			CString buf;
					buf+=toString(RS->fieldsValue[0].m_lVal); buf+=") class: ";
					buf+=RS->fieldsValue[1].m_cstring; buf+="; race: ";
					buf+=RS->fieldsValue[2].m_cstring;
			pComboBox_BusList_indexes[i]=RS->fieldsValue[0].m_lVal;
			pComboBox_BusList->InsertString(i,buf);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

bool IsSelected_Time(){
	if(pList_Time->GetCurSel()==-1){
		AfxMessageBox("Nothing selected!");
		return 0;}
	return 1;}

bool IsEmpty_List_Time(){
	if(pComboBox_TimeH->GetCurSel()==-1||
	   pComboBox_TimeM->GetCurSel()==-1){
			AfxMessageBox("No selected hour or min.!");
			return 0;}
	return 1;}

void setCurSel_List_Time(int fictionIndex){
	for(int i=0;i<*pLTiLen;i++)
		if(pList_Time_indexes[i]==fictionIndex){
			pList_Time->SetCurSel(i);
			return;}}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void CTimeForm::AddTime_onClick(){
	if(pComboBox_BusList->GetCurSel()==-1){
		AfxMessageBox("No selected bus!");
		return;}
 // >>>
	if(!IsEmpty_List_Time())return;	
 // >>>
	long newValue=pComboBox_TimeH->GetCurSel()*60+
				  pComboBox_TimeM->GetCurSel();
	long busID=pComboBox_BusList_indexes[pComboBox_BusList->GetCurSel()];
 // >>>
	CString prepSql="SELECT Time.time FROM [Time] WHERE Time.bus_ID=$$1 AND Time.time=$$2";	
			prepSql.Replace("$$1",toString(busID));
			prepSql.Replace("$$2",toString(newValue));
	if(!isUnique(prepSql,"[time]&"))return;
 // >>>
	CString insertSql="INSERT INTO [Time] (bus_ID,[time]) Values($$1,$$2)";
			insertSql.Replace("$$1",toString(busID));
			insertSql.Replace("$$2",toString(newValue));
	DB.ExecuteSQL(insertSql);
	Load_List_Time(busID);
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT Time.time_ID FROM [Time] WHERE Time.bus_ID=$$1 AND Time.time=$$2";
			getNewIdSql.Replace("$$1",toString(busID));
			getNewIdSql.Replace("$$2",toString(newValue));
		RS->Open(getNewIdSql,"[time_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_List_Time(newId);}

void CTimeForm::EditTime_onClick(){	
	if(!IsSelected_Time())return;
	if(!IsEmpty_List_Time())return;
 // >>>
	long newValue=pComboBox_TimeH->GetCurSel()*60+
				  pComboBox_TimeM->GetCurSel();
	long busID=pComboBox_BusList_indexes[pComboBox_BusList->GetCurSel()];
	long cID=pList_Time_indexes[pList_Time->GetCurSel()];
 // >>>
	CString prepSql="SELECT Time.time FROM [Time] WHERE Time.bus_ID=$$1 AND Time.time=$$2";	
			prepSql.Replace("$$1",toString(busID));
			prepSql.Replace("$$2",toString(newValue));
	if(!isUnique(prepSql,"[time]&"))return;
 // >>>
	CString updateSql="UPDATE [Time] SET [Time].bus_ID=$$1,[Time].[time]=$$2 WHERE Time.time_ID=$$3";
			updateSql.Replace("$$1",toString(busID));
			updateSql.Replace("$$2",toString(newValue));
			updateSql.Replace("$$3",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_List_Time(busID);
	setCurSel_List_Time(cID);}

void CTimeForm::DeleteTime_onClick(){
	if(!IsSelected_Time())return;
	long busID=pComboBox_BusList_indexes[pComboBox_BusList->GetCurSel()];
	long cID=pList_Time_indexes[pList_Time->GetCurSel()];
 // >>>
	CString deleteSql="DELETE Time.* FROM [Time] WHERE Time.time_ID=";
			deleteSql+=toString(cID);
	int oldSel=pList_Time->GetCurSel();
	DB.ExecuteSQL(deleteSql);
	Load_List_Time(busID);
	pList_Time->SetCurSel(oldSel>pList_Time->GetCount()-1?pList_Time->GetCount()-1:oldSel);}

void CTimeForm::timesHelp_onClick(){
	AfxMessageBox("One bus = only one race! One race - can be many bus!");}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CTimeForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CTimeForm::OnInitDialog(){CDialog::OnInitDialog();	
// >>>
	pList_Time=(CListBox*)GetDlgItem(List_Time);
	pComboBox_BusList=(CComboBox*)GetDlgItem(ComboBox_BusList);
	pComboBox_TimeH=(CComboBox*)GetDlgItem(ComboBox_TimeH);
	pComboBox_TimeM=(CComboBox*)GetDlgItem(ComboBox_TimeM);
	Load_ComboBox_BusList();
 // >>>
	return TRUE;}

void CTimeForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pList_Time_indexes();
	ClearIndexes_pComboBox_BusList_indexes();}

void CTimeForm::SelchangeBusList_onChange(){
	Load_List_Time(pComboBox_BusList_indexes[pComboBox_BusList->GetCurSel()]);}
