#include "stdafx.h"
#include "../main.h"
#include "CPathForm.h"
#include "../ExLibrary/CMyRecordset.h"
	char* toString(int value,int radix=10);
	CString IsEmpty_CEdit(CEdit* ctrl);
	void sqlFilter(CString* value);
	bool isUnique(CString sql,CString fields);
	bool isRelate(CString sql,CString fields);

CPathForm::CPathForm(CWnd* pParent):CDialog(CPathForm::IDD,pParent){
  //{{AFX_DATA_INIT(CPathForm)
  //}}AFX_DATA_INIT
	}

void CPathForm::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CPathForm)
  //}}AFX_DATA_MAP
	}

BEGIN_MESSAGE_MAP(CPathForm, CDialog)
  //{{AFX_MSG_MAP(CPathForm)
	ON_BN_CLICKED(Button_AddPath, AddPath_onClick)
	ON_BN_CLICKED(Button_EditPath, EditPath_onClick)
	ON_BN_CLICKED(Button_DeletePath, DeletePath_onClick)
	ON_BN_CLICKED(IDOK, OK_onClick)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/* ============================ 
   ===== User realization ===== 
   ============================ */

	CListBox* pList_Pathes;
	CComboBox* pComboBox_Station1;
	CComboBox* pComboBox_Station2;
	CEdit* pEdit_pathTime;

	extern CDatabase DB;
	extern CMyRecordset* RS;

/* ============================ 
   ====== indexes & Funcn ===== 
   ============================ */

	int* pList_Pathes_indexes;
	int* pLPiLen;

void ClearIndexes_pList_Pathes_indexes(){
	if(pList_Pathes_indexes){
		delete []pList_Pathes_indexes,pLPiLen;
		pList_Pathes_indexes=pLPiLen=NULL;}}

void InitIndexes_pList_Pathes_indexes(int len){
	pList_Pathes_indexes=new int[len];
   *(pLPiLen=new int)=len;}

	int* pComboBox_Stations_indexes;
	int* pCBSiLen;

void ClearIndexes_pComboBox_Stations_indexes(){
	if(pComboBox_Stations_indexes){
		delete []pComboBox_Stations_indexes,pCBSiLen;
		pComboBox_Stations_indexes=pCBSiLen=NULL;}}

void InitIndexes_pComboBox_Stations_indexes(int len){
	pComboBox_Stations_indexes=new int[len];
   *(pCBSiLen=new int)=len;}

/* ============================ 
   ====== ............... ===== 
   ============================ */

void Load_ComboBox_Stations(){
	pComboBox_Station1->ResetContent();
	pComboBox_Station2->ResetContent();
	RS=new CMyRecordset(&DB);
	RS->Open("SELECT Station.* FROM Station","[station_ID]&,[name]$");
	RS->DefineRealCount();
	ClearIndexes_pComboBox_Stations_indexes();
	if(RS->Count){
		InitIndexes_pComboBox_Stations_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pComboBox_Stations_indexes[i]=RS->fieldsValue[0].m_lVal;
			pComboBox_Station1->InsertString(i,RS->fieldsValue[1].m_cstring);
			pComboBox_Station2->InsertString(i,RS->fieldsValue[1].m_cstring);
			RS->MoveNext();}}
	RS->Close();
	delete RS;}

void Load_List_Pathes(){
	pList_Pathes->ResetContent();
	RS=new CMyRecordset(&DB);
	RS->Open("SELECT Path.path_ID, Station_1.name+' <-> '+Station_2.name+' - ('+Trim(Str(Path.time))+' min)' FROM Station AS Station_2 INNER JOIN (Station AS Station_1 INNER JOIN Path ON Station_1.station_ID = Path.[start/end station_ID]) ON Station_2.station_ID = Path.[end/start station_ID] ORDER BY Station_1.name,Station_2.name,Path.time","[path_ID]&,[Expr1001]$");
	RS->DefineRealCount();
	ClearIndexes_pList_Pathes_indexes();
	if(RS->Count){
		InitIndexes_pList_Pathes_indexes(RS->Count);
		for(int i=0;i<RS->Count;i++){
			pList_Pathes_indexes[i]=RS->fieldsValue[0].m_lVal;
			pList_Pathes->InsertString(i,RS->fieldsValue[1].m_cstring);
			RS->MoveNext();}}		
	RS->Close();
	delete RS;}

bool IsSelected_PathStations(){
	if(pComboBox_Station1->GetCurSel()==-1||
	   pComboBox_Station2->GetCurSel()==-1){
			AfxMessageBox("Nothing selected!");
			return 0;}
	return 1;}

bool IsSelected_List_Pathes(){
	if(pList_Pathes->GetCurSel()==-1){
		AfxMessageBox("Nothing selected!");
		return 0;}
	return 1;}

void setCurSel_PathStations(int fictionIndex){
	for(int i=0;i<*pLPiLen;i++)
		if(pList_Pathes_indexes[i]==fictionIndex){
			pList_Pathes->SetCurSel(i);
			return;}}

/* ============================ 
   ====== Add Edit Remove ===== 
   ============================ */

void CPathForm::AddPath_onClick(){
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_pathTime))=="") return;
	sqlFilter(&newValue);
	if(!IsSelected_PathStations())return;
 // >>>
	long Station1=pComboBox_Stations_indexes[pComboBox_Station1->GetCurSel()];
	long Station2=pComboBox_Stations_indexes[pComboBox_Station2->GetCurSel()];
 // >>>
	if(Station1==Station2){
		AfxMessageBox("Path can't be cycled!");
		return;}
 // >>>
	CString prepSql="SELECT Path.path_ID FROM Path WHERE (Path.[start/end station_ID]=$$1 OR Path.[start/end station_ID]=$$2) AND (Path.[end/start station_ID]=$$1 OR Path.[end/start station_ID]=$$2) AND (Path.time=$$3)";
			prepSql.Replace("$$1",toString(Station1));
			prepSql.Replace("$$2",toString(Station2));
			prepSql.Replace("$$3",toString(atoi(newValue)));
	if(!isUnique(prepSql,"[path_ID]&"))return;
 // >>>
	CString insertSql="INSERT INTO Path ([start/end station_ID],[end/start station_ID],[time]) Values($$1,$$2,$$3)";
			insertSql.Replace("$$1",toString(Station1));
			insertSql.Replace("$$2",toString(Station2));
			insertSql.Replace("$$3",toString(atoi(newValue)));
	DB.ExecuteSQL(insertSql);
	Load_List_Pathes();
	pEdit_pathTime->SetWindowText("");	
 // :::
	RS=new CMyRecordset(&DB);
	CString getNewIdSql="SELECT Path.path_ID FROM Path WHERE Path.[start/end station_ID]=$$1 AND Path.[end/start station_ID]=$$2 AND Path.time=$$3";
			getNewIdSql.Replace("$$1",toString(Station1));
			getNewIdSql.Replace("$$2",toString(Station2));
			getNewIdSql.Replace("$$3",toString(atoi(newValue)));
		RS->Open(getNewIdSql,"[path_ID]&");
		RS->MoveFirst();
		long newId=RS->fieldsValue[0].m_lVal;
		RS->Close();
	delete RS;
	setCurSel_PathStations(newId);}

void CPathForm::EditPath_onClick(){
	if(!IsSelected_List_Pathes())return;
 // >>>
	CString newValue;
	if((newValue=IsEmpty_CEdit(pEdit_pathTime))=="") return;
	sqlFilter(&newValue);
	if(!IsSelected_PathStations())return;
 // >>>;
	if((newValue=IsEmpty_CEdit(pEdit_pathTime))=="") return;
	sqlFilter(&newValue);
 // >>>
	long Station1=pComboBox_Stations_indexes[pComboBox_Station1->GetCurSel()];
	long Station2=pComboBox_Stations_indexes[pComboBox_Station2->GetCurSel()];
	long cID=pList_Pathes_indexes[pList_Pathes->GetCurSel()];
 // >>>
	if(Station1==Station2){
		AfxMessageBox("Path can't be cycled!");
		return;}
 // >>>
	CString prepSql="SELECT Path.path_ID FROM Path WHERE (Path.[start/end station_ID]=$$1 OR Path.[start/end station_ID]=$$2) AND (Path.[end/start station_ID]=$$1 OR Path.[end/start station_ID]=$$2) AND (Path.time=$$3);";
			prepSql.Replace("$$1",toString(Station1));
			prepSql.Replace("$$2",toString(Station2));
			prepSql.Replace("$$3",toString(atoi(newValue)));
	if(!isUnique(prepSql,"[path_ID]&"))return;
 // >>>
	CString updateSql="UPDATE Path SET Path.[start/end station_ID]=$$1, Path.[end/start station_ID]=$$2, Path.[time]=$$3 WHERE Path.path_ID=$$4";
			updateSql.Replace("$$1",toString(Station1));
			updateSql.Replace("$$2",toString(Station2));
			updateSql.Replace("$$3",newValue);
			updateSql.Replace("$$4",toString(cID));
	DB.ExecuteSQL(updateSql);
	Load_List_Pathes();
	pEdit_pathTime->SetWindowText("");	
	setCurSel_PathStations(cID);}

void CPathForm::DeletePath_onClick(){
	if(!IsSelected_List_Pathes())return;
 // >>>
	long cID=pList_Pathes_indexes[pList_Pathes->GetCurSel()];
 // >>>
	CString relateTestSql="SELECT [Race items].race_ID FROM [Race items] WHERE [Race items].path_ID=$$$";
			relateTestSql.Replace("$$$",toString(cID));
	if(isRelate(relateTestSql,"[race_ID]&"))return;
 // >>>
	CString deleteSql="DELETE Path.* FROM Path WHERE Path.path_ID=$$$";
			deleteSql.Replace("$$$",toString(cID));
	DB.ExecuteSQL(deleteSql);
	long oldSel=pList_Pathes->GetCurSel();
	Load_List_Pathes();
 // :::
	pList_Pathes->SetCurSel(oldSel>pList_Pathes->GetCount()-1?pList_Pathes->GetCount()-1:oldSel);}

/* ============================ 
   === OnInitDialog OnClose === 
   ============================ */

void CPathForm::OK_onClick(){SendMessage(WM_CLOSE,0,0);}

BOOL CPathForm::OnInitDialog(){CDialog::OnInitDialog();
// >>>
	pList_Pathes=(CListBox*)GetDlgItem(List_Pathes);
	pComboBox_Station1=(CComboBox*)GetDlgItem(ComboBox_Station1);
	pComboBox_Station2=(CComboBox*)GetDlgItem(ComboBox_Station2);
	pEdit_pathTime=(CEdit*)GetDlgItem(Edit_pathTime);
 // >>>
	Load_ComboBox_Stations();
	Load_List_Pathes();
 // >>>
	return TRUE;}

void CPathForm::OnClose(){CDialog::OnClose();
	ClearIndexes_pComboBox_Stations_indexes();
	ClearIndexes_pList_Pathes_indexes();}
